unit VCDLG32;{24 Sept 2000, 4:00:10am}

interface

uses WinTypes, VCType32;

function VCLoadVCDLG32: boolean;
procedure VCFreeVCDLG32;
procedure VCAddPlotter (var iError: Smallint; szPlotterName: PChar); stdcall;
procedure VCAddPlotterLanguageName (var iError: Smallint; szLanguageName: PChar); stdcall;
procedure VCAddPlotterPageSize (var iError: Smallint; var pPageSize: Point2D); stdcall;
procedure VCAddPlotterPenMapName (var iError: Smallint; szPenMapName: PChar); stdcall;
procedure VCApplyPlotterLanguageDefaults (var iError: Smallint); stdcall;
procedure VCApplyPlotterPenMapDefaults (var iError: Smallint); stdcall;
procedure VCBirdsEye (var iError: Smallint; iDisplayMode: Smallint); stdcall;
procedure VCChangeRefFrameNameDlg (var iError: Smallint); stdcall;
procedure VCChangeRibalog; stdcall;
procedure VCCloseRibalog (var iError: Smallint); stdcall;
procedure VCDBLineSettingsRibalog; stdcall;
procedure VCDeInitPrintMode (var iError: Smallint); stdcall;
procedure VCDimArrowRibalog; stdcall;
procedure VCDimDisplayRibalog; stdcall;
procedure VCDimExtRibalog; stdcall;
procedure VCDimLeaderRibalog; stdcall;
procedure VCDimLineRibalog; stdcall;
procedure VCDimStringsRibalog; stdcall;
procedure VCDimTextRibalog; stdcall;
procedure VCDimToleranceRibalog; stdcall;
procedure VCFilletRadiusRibalog; stdcall;
procedure VCFilterRibalog; stdcall;
function VCGetCurrentPrinter (var iError: Smallint; szPrinter: PChar): Smallint; stdcall;
function VCGetDefaultPrinter (var iError: Smallint; szDefaultPrinter: PChar): Smallint; stdcall;
function VCGetDialogFromId (id: Word): HWND; stdcall;
function VCGetMainHMenu: HMENU; stdcall;
procedure VCGetPlotSettings (var iError: Smallint; var pSettings: PlotStruct); stdcall;
function VCGetPlotterCount (var iError: Smallint): Smallint; stdcall;
function VCGetPlotterCurrentLanguageName (var iError: Smallint; szLanguageName: PChar): Smallint; stdcall;
procedure VCGetPlotterCurrentPageSize (var iError: Smallint; var iIndex: Smallint; var pPaperSize: Point2D); stdcall;
function VCGetPlotterCurrentPenMapName (var iError: Smallint; szPenMapName: PChar): Smallint; stdcall;
function VCGetPlotterDeInitString (var iError: Smallint; sz: PChar): Smallint; stdcall;
function VCGetPlotterDelimiter (var iError: Smallint; sz: PChar): Smallint; stdcall;
function VCGetPlotterInitString (var iError: Smallint; sz: PChar): Smallint; stdcall;
function VCGetPlotterLanguageCount (var iError: Smallint): Smallint; stdcall;
function VCGetPlotterLanguageName (var iError: Smallint; iIndex: Smallint; szLanguageName: PChar): Smallint; stdcall;
procedure VCGetPlotterPageSize (var iError: Smallint; iIndex: Smallint; var pPaperSize: Point2D); stdcall;
function VCGetPlotterPageSizeCount (var iError: Smallint): Smallint; stdcall;
function VCGetPlotterPenChangeString (var iError: Smallint; sz: PChar): Smallint; stdcall;
function VCGetPlotterPenDownString (var iError: Smallint; sz: PChar): Smallint; stdcall;
function VCGetPlotterPenDrawString (var iError: Smallint; sz: PChar): Smallint; stdcall;
function VCGetPlotterPenMapCount (var iError: Smallint): Smallint; stdcall;
function VCGetPlotterPenMapName (var iError: Smallint; iIndex: Smallint; szPenMapName: PChar): Smallint; stdcall;
procedure VCGetPlotterPenMapping (var iError: Smallint; iColor: Smallint; var iPen: Smallint; var dWidth: Double; var iSpeed: Smallint); stdcall;
function VCGetPlotterPenMoveString (var iError: Smallint; sz: PChar): Smallint; stdcall;
function VCGetPlotterPenSpeedString (var iError: Smallint; sz: PChar): Smallint; stdcall;
function VCGetPlotterPenUpString (var iError: Smallint; sz: PChar): Smallint; stdcall;
procedure VCGetPrintSettings (var iError: Smallint; var pSettings: PrintStruct); stdcall;
function VCGetPrinterName (var iError: Smallint; iIndex: Smallint; szPrinter: PChar): Smallint; stdcall;
function VCGetPrinterNameCount (var iError: Smallint): Smallint; stdcall;
procedure VCGetRibalogSize (var iError: Smallint; var ipOrg: iPoint2D; var ipSize: iPoint2D); stdcall;
function VCGetSpecificPrinter (var iError: Smallint; szSpecificPrinter: PChar): Smallint; stdcall;
procedure VCGetStatusBarSize (var iError: Smallint; var ipOrg: iPoint2D; var ipSize: iPoint2D); stdcall;
function VCGetToolbar (i: Smallint): HWND; stdcall;
function VCGetTopTool: HWND; stdcall;
function VCGetUseHPGL2 (var iError: Smallint): WordBool; stdcall;
procedure VCHatchSettingsRibalog; stdcall;
procedure VCInitDialogs; stdcall;
procedure VCInitPrintMode (var iError: Smallint; iPrintMode: Smallint); stdcall;
procedure VCLayerMgr (var iError: Smallint); stdcall;
procedure VCLoadAlias (szFile: PChar; var iError: Smallint); stdcall;
procedure VCLoadCmdExt (szFile: PChar; var iError: Smallint); stdcall;
procedure VCLoadMainSpeedbar (szFile: PChar; var iError: Smallint); stdcall;
procedure VCLoadPlotterDriver (var iError: Smallint; szName: PChar); stdcall;
procedure VCLoadPlotterLanguage (var iError: Smallint; szName: PChar); stdcall;
procedure VCLoadPlotterPenMap (var iError: Smallint; szName: PChar); stdcall;
procedure VCLoadToolPalette (szFile: PChar; var iError: Smallint); stdcall;
procedure VCMeasureAngleRibalog; stdcall;
procedure VCMeasureAreaRibalog; stdcall;
procedure VCMeasureDistRibalog; stdcall;
procedure VCModalDlg (var iError: Smallint; cmd_id: Longint); stdcall;
procedure VCNoDrawingSpeedbar (var iError: Smallint); stdcall;
procedure VCObjectInfo (var iError: Smallint); stdcall;
procedure VCOffsetRibalog; stdcall;
procedure VCOrthoAngleRibalog; stdcall;
procedure VCPlot (var iError: Smallint); stdcall;
procedure VCPlotDlg (var iError: Smallint); stdcall;
procedure VCPrint (var iError: Smallint); stdcall;
procedure VCPrintDlg (var iError: Smallint); stdcall;
procedure VCPropertiesRibalog; stdcall;
procedure VCRFBirdsEye (var iError: Smallint); stdcall;
procedure VCRFLayerMgr (var iError: Smallint); stdcall;
function VCRIsButtonDown (var iError: Smallint; szNative: PChar; id: Word): WordBool; stdcall;
procedure VCRemovePlotterPageSize (var iError: Smallint; iIndex: Smallint); stdcall;
procedure VCResetCmdExt (var iError: Smallint); stdcall;
procedure VCResetPrintMargins (var iError: Smallint); stdcall;
procedure VCSavePlotterDriver (var iError: Smallint; szName: PChar); stdcall;
procedure VCSavePlotterLanguage (var iError: Smallint; szName: PChar); stdcall;
procedure VCSavePlotterPenMap (var iError: Smallint; szName: PChar); stdcall;
procedure VCScriptAssignRibalog; stdcall;
procedure VCSetDefaultPrinter (var iError: Smallint; szDefaultPrinter: PChar); stdcall;
procedure VCSetDialogFrameHwnd (hWndFrame: Longword); stdcall;
procedure VCSetEmbedded (tfEmbedded: WordBool); stdcall;
procedure VCSetPlotSettings (var iError: Smallint; var pSettings: PlotStruct); stdcall;
procedure VCSetPlotterCurrentLanguageIndex (var iError: Smallint; iIndex: Smallint); stdcall;
procedure VCSetPlotterCurrentLanguageName (var iError: Smallint; szLanguageName: PChar); stdcall;
procedure VCSetPlotterCurrentPageSize (var iError: Smallint; iIndex: Smallint); stdcall;
procedure VCSetPlotterCurrentPenMapIndex (var iError: Smallint; iIndex: Smallint); stdcall;
procedure VCSetPlotterCurrentPenMapName (var iError: Smallint; szPenMapName: PChar); stdcall;
procedure VCSetPlotterDeInitString (var iError: Smallint; sz: PChar); stdcall;
procedure VCSetPlotterDelimiter (var iError: Smallint; sz: PChar); stdcall;
procedure VCSetPlotterInitString (var iError: Smallint; sz: PChar); stdcall;
procedure VCSetPlotterPenChangeString (var iError: Smallint; sz: PChar); stdcall;
procedure VCSetPlotterPenDownString (var iError: Smallint; sz: PChar); stdcall;
procedure VCSetPlotterPenDrawString (var iError: Smallint; sz: PChar); stdcall;
procedure VCSetPlotterPenMapping (var iError: Smallint; iColor: Smallint; iPen: Smallint; dWidth: Double; iSpeed: Smallint); stdcall;
procedure VCSetPlotterPenMoveString (var iError: Smallint; sz: PChar); stdcall;
procedure VCSetPlotterPenSpeedString (var iError: Smallint; sz: PChar); stdcall;
procedure VCSetPlotterPenUpString (var iError: Smallint; sz: PChar); stdcall;
procedure VCSetPrintSettings (var iError: Smallint; var pSettings: PrintStruct); stdcall;
procedure VCSetRefFrameNameDlg (var iError: Smallint); stdcall;
procedure VCSetSpecificPrinter (var iError: Smallint; szSpecificPrinter: PChar); stdcall;
procedure VCSetUseHPGL2 (var iError: Smallint; tf: WordBool); stdcall;
procedure VCSymCreateRibalog; stdcall;
procedure VCSymPlaceRibalog; stdcall;
procedure VCSymbolMgr (var iError: Smallint); stdcall;
procedure VCTerminateDialogs; stdcall;
procedure VCTextLineRibalog; stdcall;
procedure VCTextSettingsRibalog; stdcall;
procedure VCUpdateBirdseyeView (var iError: Smallint; tfRefresh: WordBool); stdcall;
procedure VCUpdateDialog (var iError: Smallint); stdcall;
procedure VCAddPrintPreset (var iError: Smallint; szPresetName: PChar); stdcall;
procedure VCDeletePrintPreset (var iError: Smallint; szPresetName: PChar); stdcall;
procedure VCSetCurrentPrintPreset (var iError: Smallint; szPresetName: PChar); stdcall;
function VCGetCurrentPrintPreset (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
procedure VCSetPrintPresetDevice (var iError: Smallint; szPresetName: PChar; szDevice: PChar); stdcall;
function VCGetPrintPresetDevice (var iError: Smallint; szPresetName: PChar; szDevice: PChar): Longint; stdcall;
procedure VCSetPrintPresetPageWidth (var iError: Smallint; szPresetName: PChar; dPageWidth: Double); stdcall;
function VCGetPrintPresetPageWidth (var iError: Smallint; szPresetName: PChar): Double; stdcall;
procedure VCSetPrintPresetPageHeight (var iError: Smallint; szPresetName: PChar; dPageHeight: Double); stdcall;
function VCGetPrintPresetPageHeight (var iError: Smallint; szPresetName: PChar): Double; stdcall;
procedure VCSetPrintPresetMarginLeft (var iError: Smallint; szPresetName: PChar; dMarginLeft: Double); stdcall;
function VCGetPrintPresetMarginLeft (var iError: Smallint; szPresetName: PChar): Double; stdcall;
procedure VCSetPrintPresetMarginBottom (var iError: Smallint; szPresetName: PChar; dMarginBottom: Double); stdcall;
function VCGetPrintPresetMarginBottom (var iError: Smallint; szPresetName: PChar): Double; stdcall;
procedure VCSetPrintPresetMarginRight (var iError: Smallint; szPresetName: PChar; dMarginRight: Double); stdcall;
function VCGetPrintPresetMarginRight (var iError: Smallint; szPresetName: PChar): Double; stdcall;
procedure VCSetPrintPresetMarginTop (var iError: Smallint; szPresetName: PChar; dMarginTop: Double); stdcall;
function VCGetPrintPresetMarginTop (var iError: Smallint; szPresetName: PChar): Double; stdcall;
procedure VCSetPrintPresetPrintScale (var iError: Smallint; szPresetName: PChar; dPrintScale: Double); stdcall;
function VCGetPrintPresetPrintScale (var iError: Smallint; szPresetName: PChar): Double; stdcall;
procedure VCSetPrintPresetOriginBP (var iError: Smallint; szPresetName: PChar; var pOrigin: Point2D); stdcall;
procedure VCGetPrintPresetOriginBP (var iError: Smallint; szPresetName: PChar; var pOrigin: Point2D); stdcall;
procedure VCSetPrintPresetOriginX (var iError: Smallint; szPresetName: PChar; dOriginX: Double); stdcall;
function VCGetPrintPresetOriginX (var iError: Smallint; szPresetName: PChar): Double; stdcall;
procedure VCSetPrintPresetOriginY (var iError: Smallint; szPresetName: PChar; dOriginY: Double); stdcall;
function VCGetPrintPresetOriginY (var iError: Smallint; szPresetName: PChar): Double; stdcall;
procedure VCSetPrintPresetPrintView (var iError: Smallint; szPresetName: PChar; nPrintView: Longint); stdcall;
function VCGetPrintPresetPrintView (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
procedure VCSetPrintPresetLandscape (var iError: Smallint; szPresetName: PChar; tfLandscape: WordBool); stdcall;
function VCGetPrintPresetLandscape (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
procedure VCSetPrintPresetCopies (var iError: Smallint; szPresetName: PChar; nCopies: Longint); stdcall;
function VCGetPrintPresetCopies (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
procedure VCSetPrintPresetRotation (var iError: Smallint; szPresetName: PChar; dRotation: Double); stdcall;
function VCGetPrintPresetRotation (var iError: Smallint; szPresetName: PChar): Double; stdcall;
procedure VCSetPrintPresetMetric (var iError: Smallint; szPresetName: PChar; tfMetric: WordBool); stdcall;
function VCGetPrintPresetMetric (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
procedure VCSetPrintPresetFastRedraw (var iError: Smallint; szPresetName: PChar; tfFastRedraw: WordBool); stdcall;
function VCGetPrintPresetFastRedraw (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
procedure VCSetPrintPresetPrintSelected (var iError: Smallint; szPresetName: PChar; tfPrintSelected: WordBool); stdcall;
function VCGetPrintPresetPrintSelected (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
procedure VCSetPrintPresetPrintToFile (var iError: Smallint; szPresetName: PChar; tfPrintToFile: WordBool); stdcall;
function VCGetPrintPresetPrintToFile (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
procedure VCSetPrintPresetDateStamp (var iError: Smallint; szPresetName: PChar; tfDateStamp: WordBool); stdcall;
function VCGetPrintPresetDateStamp (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
procedure VCSetPrintPresetAllToBlack (var iError: Smallint; szPresetName: PChar; tfAllToBlack: WordBool); stdcall;
function VCGetPrintPresetAllToBlack (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
procedure VCSetPrintPresetLW0HasWidth (var iError: Smallint; szPresetName: PChar; tfLW0HasWidth: WordBool); stdcall;
function VCGetPrintPresetLW0HasWidth (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
procedure VCSetPrintPresetLineWidth (var iError: Smallint; szPresetName: PChar; dLineWidth: Double); stdcall;
function VCGetPrintPresetLineWidth (var iError: Smallint; szPresetName: PChar): Double; stdcall;
procedure VCSetPrintPresetMovePage (var iError: Smallint; szPresetName: PChar; tfMovePage: WordBool); stdcall;
function VCGetPrintPresetMovePage (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
procedure VCSetPrintPresetShowPreview (var iError: Smallint; szPresetName: PChar; tfShowPreview: WordBool); stdcall;
function VCGetPrintPresetShowPreview (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
procedure VCSetPrintPresetPaperSize (var iError: Smallint; szPresetName: PChar; nPaperSize: Longint); stdcall;
function VCGetPrintPresetPaperSize (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
procedure VCSetPrintPresetPaperLength (var iError: Smallint; szPresetName: PChar; nPaperLength: Longint); stdcall;
function VCGetPrintPresetPaperLength (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
procedure VCSetPrintPresetPaperWidth (var iError: Smallint; szPresetName: PChar; nPaperWidth: Longint); stdcall;
function VCGetPrintPresetPaperWidth (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
procedure VCSetPrintPresetAlwaysCenter (var iError: Smallint; szPresetName: PChar; tfAlwaysCenter: WordBool); stdcall;
function VCGetPrintPresetAlwaysCenter (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
procedure VCSetPrintPresetStampFormat (var iError: Smallint; szPresetName: PChar; nStampFormat: Longint); stdcall;
function VCGetPrintPresetStampFormat (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
procedure VCSetPrintPresetStampFontSize (var iError: Smallint; szPresetName: PChar; nStampFontSize: Longint); stdcall;
function VCGetPrintPresetStampFontSize (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
procedure VCSetPrintPresetStampLocation (var iError: Smallint; szPresetName: PChar; nStampLocation: Longint); stdcall;
function VCGetPrintPresetStampLocation (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
procedure VCSetPrintPresetStampFont (var iError: Smallint; szPresetName: PChar; szStampFont: PChar); stdcall;
function VCGetPrintPresetStampFont (var iError: Smallint; szPresetName: PChar; szStampFont: PChar): Longint; stdcall;
procedure VCPrintNoDlg (var iError: Smallint); stdcall;

implementation

var hInst: THandle;

function VCLoadVCDLG32: boolean;
begin
  hInst := LoadLibrary('VCDLG32.DLL');
  result := hInst <> 0;
end;

procedure VCFreeVCDLG32;
begin
  if hInst <> 0 then
    FreeLibrary(hInst);
end;

procedure VCAddPlotter (var iError: Smallint; szPlotterName: PChar);
type TVCProc = procedure (var iError: Smallint; szPlotterName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAddPlotter');
    if @aproc <> nil then
      aproc(iError, szPlotterName);
  end;
end;

procedure VCAddPlotterLanguageName (var iError: Smallint; szLanguageName: PChar);
type TVCProc = procedure (var iError: Smallint; szLanguageName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAddPlotterLanguageName');
    if @aproc <> nil then
      aproc(iError, szLanguageName);
  end;
end;

procedure VCAddPlotterPageSize (var iError: Smallint; var pPageSize: Point2D);
type TVCProc = procedure (var iError: Smallint; var pPageSize: Point2D); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAddPlotterPageSize');
    if @aproc <> nil then
      aproc(iError, pPageSize);
  end;
end;

procedure VCAddPlotterPenMapName (var iError: Smallint; szPenMapName: PChar);
type TVCProc = procedure (var iError: Smallint; szPenMapName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAddPlotterPenMapName');
    if @aproc <> nil then
      aproc(iError, szPenMapName);
  end;
end;

procedure VCApplyPlotterLanguageDefaults (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCApplyPlotterLanguageDefaults');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCApplyPlotterPenMapDefaults (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCApplyPlotterPenMapDefaults');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCBirdsEye (var iError: Smallint; iDisplayMode: Smallint);
type TVCProc = procedure (var iError: Smallint; iDisplayMode: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCBirdsEye');
    if @aproc <> nil then
      aproc(iError, iDisplayMode);
  end;
end;

procedure VCChangeRefFrameNameDlg (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCChangeRefFrameNameDlg');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCChangeRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCChangeRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCCloseRibalog (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCCloseRibalog');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCDBLineSettingsRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDBLineSettingsRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDeInitPrintMode (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDeInitPrintMode');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCDimArrowRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDimArrowRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDimDisplayRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDimDisplayRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDimExtRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDimExtRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDimLeaderRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDimLeaderRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDimLineRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDimLineRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDimStringsRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDimStringsRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDimTextRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDimTextRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCDimToleranceRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDimToleranceRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCFilletRadiusRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCFilletRadiusRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCFilterRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCFilterRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

function VCGetCurrentPrinter (var iError: Smallint; szPrinter: PChar): Smallint;
type TVCProc = function (var iError: Smallint; szPrinter: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetCurrentPrinter');
    if @aproc <> nil then
      result := aproc(iError, szPrinter);
  end;
end;

function VCGetDefaultPrinter (var iError: Smallint; szDefaultPrinter: PChar): Smallint;
type TVCProc = function (var iError: Smallint; szDefaultPrinter: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetDefaultPrinter');
    if @aproc <> nil then
      result := aproc(iError, szDefaultPrinter);
  end;
end;

function VCGetDialogFromId (id: Word): HWND;
type TVCProc = function (id: Word): HWND; stdcall;
var aproc: TVCProc;
begin
  result := HWND(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetDialogFromId');
    if @aproc <> nil then
      result := aproc(id);
  end;
end;

function VCGetMainHMenu: HMENU;
type TVCProc = function: HMENU; stdcall;
var aproc: TVCProc;
begin
  result := HMENU(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetMainHMenu');
    if @aproc <> nil then
      result := aproc;
  end;
end;

procedure VCGetPlotSettings (var iError: Smallint; var pSettings: PlotStruct);
type TVCProc = procedure (var iError: Smallint; var pSettings: PlotStruct); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotSettings');
    if @aproc <> nil then
      aproc(iError, pSettings);
  end;
end;

function VCGetPlotterCount (var iError: Smallint): Smallint;
type TVCProc = function (var iError: Smallint): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterCount');
    if @aproc <> nil then
      result := aproc(iError);
  end;
end;

function VCGetPlotterCurrentLanguageName (var iError: Smallint; szLanguageName: PChar): Smallint;
type TVCProc = function (var iError: Smallint; szLanguageName: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterCurrentLanguageName');
    if @aproc <> nil then
      result := aproc(iError, szLanguageName);
  end;
end;

procedure VCGetPlotterCurrentPageSize (var iError: Smallint; var iIndex: Smallint; var pPaperSize: Point2D);
type TVCProc = procedure (var iError: Smallint; var iIndex: Smallint; var pPaperSize: Point2D); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterCurrentPageSize');
    if @aproc <> nil then
      aproc(iError, iIndex, pPaperSize);
  end;
end;

function VCGetPlotterCurrentPenMapName (var iError: Smallint; szPenMapName: PChar): Smallint;
type TVCProc = function (var iError: Smallint; szPenMapName: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterCurrentPenMapName');
    if @aproc <> nil then
      result := aproc(iError, szPenMapName);
  end;
end;

function VCGetPlotterDeInitString (var iError: Smallint; sz: PChar): Smallint;
type TVCProc = function (var iError: Smallint; sz: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterDeInitString');
    if @aproc <> nil then
      result := aproc(iError, sz);
  end;
end;

function VCGetPlotterDelimiter (var iError: Smallint; sz: PChar): Smallint;
type TVCProc = function (var iError: Smallint; sz: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterDelimiter');
    if @aproc <> nil then
      result := aproc(iError, sz);
  end;
end;

function VCGetPlotterInitString (var iError: Smallint; sz: PChar): Smallint;
type TVCProc = function (var iError: Smallint; sz: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterInitString');
    if @aproc <> nil then
      result := aproc(iError, sz);
  end;
end;

function VCGetPlotterLanguageCount (var iError: Smallint): Smallint;
type TVCProc = function (var iError: Smallint): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterLanguageCount');
    if @aproc <> nil then
      result := aproc(iError);
  end;
end;

function VCGetPlotterLanguageName (var iError: Smallint; iIndex: Smallint; szLanguageName: PChar): Smallint;
type TVCProc = function (var iError: Smallint; iIndex: Smallint; szLanguageName: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterLanguageName');
    if @aproc <> nil then
      result := aproc(iError, iIndex, szLanguageName);
  end;
end;

procedure VCGetPlotterPageSize (var iError: Smallint; iIndex: Smallint; var pPaperSize: Point2D);
type TVCProc = procedure (var iError: Smallint; iIndex: Smallint; var pPaperSize: Point2D); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterPageSize');
    if @aproc <> nil then
      aproc(iError, iIndex, pPaperSize);
  end;
end;

function VCGetPlotterPageSizeCount (var iError: Smallint): Smallint;
type TVCProc = function (var iError: Smallint): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterPageSizeCount');
    if @aproc <> nil then
      result := aproc(iError);
  end;
end;

function VCGetPlotterPenChangeString (var iError: Smallint; sz: PChar): Smallint;
type TVCProc = function (var iError: Smallint; sz: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterPenChangeString');
    if @aproc <> nil then
      result := aproc(iError, sz);
  end;
end;

function VCGetPlotterPenDownString (var iError: Smallint; sz: PChar): Smallint;
type TVCProc = function (var iError: Smallint; sz: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterPenDownString');
    if @aproc <> nil then
      result := aproc(iError, sz);
  end;
end;

function VCGetPlotterPenDrawString (var iError: Smallint; sz: PChar): Smallint;
type TVCProc = function (var iError: Smallint; sz: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterPenDrawString');
    if @aproc <> nil then
      result := aproc(iError, sz);
  end;
end;

function VCGetPlotterPenMapCount (var iError: Smallint): Smallint;
type TVCProc = function (var iError: Smallint): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterPenMapCount');
    if @aproc <> nil then
      result := aproc(iError);
  end;
end;

function VCGetPlotterPenMapName (var iError: Smallint; iIndex: Smallint; szPenMapName: PChar): Smallint;
type TVCProc = function (var iError: Smallint; iIndex: Smallint; szPenMapName: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterPenMapName');
    if @aproc <> nil then
      result := aproc(iError, iIndex, szPenMapName);
  end;
end;

procedure VCGetPlotterPenMapping (var iError: Smallint; iColor: Smallint; var iPen: Smallint; var dWidth: Double; var iSpeed: Smallint);
type TVCProc = procedure (var iError: Smallint; iColor: Smallint; var iPen: Smallint; var dWidth: Double; var iSpeed: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterPenMapping');
    if @aproc <> nil then
      aproc(iError, iColor, iPen, dWidth, iSpeed);
  end;
end;

function VCGetPlotterPenMoveString (var iError: Smallint; sz: PChar): Smallint;
type TVCProc = function (var iError: Smallint; sz: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterPenMoveString');
    if @aproc <> nil then
      result := aproc(iError, sz);
  end;
end;

function VCGetPlotterPenSpeedString (var iError: Smallint; sz: PChar): Smallint;
type TVCProc = function (var iError: Smallint; sz: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterPenSpeedString');
    if @aproc <> nil then
      result := aproc(iError, sz);
  end;
end;

function VCGetPlotterPenUpString (var iError: Smallint; sz: PChar): Smallint;
type TVCProc = function (var iError: Smallint; sz: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPlotterPenUpString');
    if @aproc <> nil then
      result := aproc(iError, sz);
  end;
end;

procedure VCGetPrintSettings (var iError: Smallint; var pSettings: PrintStruct);
type TVCProc = procedure (var iError: Smallint; var pSettings: PrintStruct); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintSettings');
    if @aproc <> nil then
      aproc(iError, pSettings);
  end;
end;

function VCGetPrinterName (var iError: Smallint; iIndex: Smallint; szPrinter: PChar): Smallint;
type TVCProc = function (var iError: Smallint; iIndex: Smallint; szPrinter: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrinterName');
    if @aproc <> nil then
      result := aproc(iError, iIndex, szPrinter);
  end;
end;

function VCGetPrinterNameCount (var iError: Smallint): Smallint;
type TVCProc = function (var iError: Smallint): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrinterNameCount');
    if @aproc <> nil then
      result := aproc(iError);
  end;
end;

procedure VCGetRibalogSize (var iError: Smallint; var ipOrg: iPoint2D; var ipSize: iPoint2D);
type TVCProc = procedure (var iError: Smallint; var ipOrg: iPoint2D; var ipSize: iPoint2D); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetRibalogSize');
    if @aproc <> nil then
      aproc(iError, ipOrg, ipSize);
  end;
end;

function VCGetSpecificPrinter (var iError: Smallint; szSpecificPrinter: PChar): Smallint;
type TVCProc = function (var iError: Smallint; szSpecificPrinter: PChar): Smallint; stdcall;
var aproc: TVCProc;
begin
  result := Smallint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetSpecificPrinter');
    if @aproc <> nil then
      result := aproc(iError, szSpecificPrinter);
  end;
end;

procedure VCGetStatusBarSize (var iError: Smallint; var ipOrg: iPoint2D; var ipSize: iPoint2D);
type TVCProc = procedure (var iError: Smallint; var ipOrg: iPoint2D; var ipSize: iPoint2D); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetStatusBarSize');
    if @aproc <> nil then
      aproc(iError, ipOrg, ipSize);
  end;
end;

function VCGetToolbar (i: Smallint): HWND;
type TVCProc = function (i: Smallint): HWND; stdcall;
var aproc: TVCProc;
begin
  result := HWND(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetToolbar');
    if @aproc <> nil then
      result := aproc(i);
  end;
end;

function VCGetTopTool: HWND;
type TVCProc = function: HWND; stdcall;
var aproc: TVCProc;
begin
  result := HWND(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetTopTool');
    if @aproc <> nil then
      result := aproc;
  end;
end;

function VCGetUseHPGL2 (var iError: Smallint): WordBool;
type TVCProc = function (var iError: Smallint): WordBool; stdcall;
var aproc: TVCProc;
begin
  result := WordBool(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetUseHPGL2');
    if @aproc <> nil then
      result := aproc(iError);
  end;
end;

procedure VCHatchSettingsRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCHatchSettingsRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCInitDialogs;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCInitDialogs');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCInitPrintMode (var iError: Smallint; iPrintMode: Smallint);
type TVCProc = procedure (var iError: Smallint; iPrintMode: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCInitPrintMode');
    if @aproc <> nil then
      aproc(iError, iPrintMode);
  end;
end;

procedure VCLayerMgr (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCLayerMgr');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCLoadAlias (szFile: PChar; var iError: Smallint);
type TVCProc = procedure (szFile: PChar; var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCLoadAlias');
    if @aproc <> nil then
      aproc(szFile, iError);
  end;
end;

procedure VCLoadCmdExt (szFile: PChar; var iError: Smallint);
type TVCProc = procedure (szFile: PChar; var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCLoadCmdExt');
    if @aproc <> nil then
      aproc(szFile, iError);
  end;
end;

procedure VCLoadMainSpeedbar (szFile: PChar; var iError: Smallint);
type TVCProc = procedure (szFile: PChar; var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCLoadMainSpeedbar');
    if @aproc <> nil then
      aproc(szFile, iError);
  end;
end;

procedure VCLoadPlotterDriver (var iError: Smallint; szName: PChar);
type TVCProc = procedure (var iError: Smallint; szName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCLoadPlotterDriver');
    if @aproc <> nil then
      aproc(iError, szName);
  end;
end;

procedure VCLoadPlotterLanguage (var iError: Smallint; szName: PChar);
type TVCProc = procedure (var iError: Smallint; szName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCLoadPlotterLanguage');
    if @aproc <> nil then
      aproc(iError, szName);
  end;
end;

procedure VCLoadPlotterPenMap (var iError: Smallint; szName: PChar);
type TVCProc = procedure (var iError: Smallint; szName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCLoadPlotterPenMap');
    if @aproc <> nil then
      aproc(iError, szName);
  end;
end;

procedure VCLoadToolPalette (szFile: PChar; var iError: Smallint);
type TVCProc = procedure (szFile: PChar; var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCLoadToolPalette');
    if @aproc <> nil then
      aproc(szFile, iError);
  end;
end;

procedure VCMeasureAngleRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMeasureAngleRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCMeasureAreaRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMeasureAreaRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCMeasureDistRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCMeasureDistRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCModalDlg (var iError: Smallint; cmd_id: Longint);
type TVCProc = procedure (var iError: Smallint; cmd_id: Longint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCModalDlg');
    if @aproc <> nil then
      aproc(iError, cmd_id);
  end;
end;

procedure VCNoDrawingSpeedbar (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCNoDrawingSpeedbar');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCObjectInfo (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCObjectInfo');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCOffsetRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCOffsetRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCOrthoAngleRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCOrthoAngleRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCPlot (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCPlot');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCPlotDlg (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCPlotDlg');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCPrint (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCPrint');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCPrintDlg (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCPrintDlg');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCPropertiesRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCPropertiesRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCRFBirdsEye (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRFBirdsEye');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCRFLayerMgr (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRFLayerMgr');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

function VCRIsButtonDown (var iError: Smallint; szNative: PChar; id: Word): WordBool;
type TVCProc = function (var iError: Smallint; szNative: PChar; id: Word): WordBool; stdcall;
var aproc: TVCProc;
begin
  result := WordBool(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRIsButtonDown');
    if @aproc <> nil then
      result := aproc(iError, szNative, id);
  end;
end;

procedure VCRemovePlotterPageSize (var iError: Smallint; iIndex: Smallint);
type TVCProc = procedure (var iError: Smallint; iIndex: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCRemovePlotterPageSize');
    if @aproc <> nil then
      aproc(iError, iIndex);
  end;
end;

procedure VCResetCmdExt (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCResetCmdExt');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCResetPrintMargins (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCResetPrintMargins');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCSavePlotterDriver (var iError: Smallint; szName: PChar);
type TVCProc = procedure (var iError: Smallint; szName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSavePlotterDriver');
    if @aproc <> nil then
      aproc(iError, szName);
  end;
end;

procedure VCSavePlotterLanguage (var iError: Smallint; szName: PChar);
type TVCProc = procedure (var iError: Smallint; szName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSavePlotterLanguage');
    if @aproc <> nil then
      aproc(iError, szName);
  end;
end;

procedure VCSavePlotterPenMap (var iError: Smallint; szName: PChar);
type TVCProc = procedure (var iError: Smallint; szName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSavePlotterPenMap');
    if @aproc <> nil then
      aproc(iError, szName);
  end;
end;

procedure VCScriptAssignRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCScriptAssignRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSetDefaultPrinter (var iError: Smallint; szDefaultPrinter: PChar);
type TVCProc = procedure (var iError: Smallint; szDefaultPrinter: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetDefaultPrinter');
    if @aproc <> nil then
      aproc(iError, szDefaultPrinter);
  end;
end;

procedure VCSetDialogFrameHwnd (hWndFrame: Longword);
type TVCProc = procedure (hWndFrame: Longword); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetDialogFrameHwnd');
    if @aproc <> nil then
      aproc(hWndFrame);
  end;
end;

procedure VCSetEmbedded (tfEmbedded: WordBool);
type TVCProc = procedure (tfEmbedded: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetEmbedded');
    if @aproc <> nil then
      aproc(tfEmbedded);
  end;
end;

procedure VCSetPlotSettings (var iError: Smallint; var pSettings: PlotStruct);
type TVCProc = procedure (var iError: Smallint; var pSettings: PlotStruct); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPlotSettings');
    if @aproc <> nil then
      aproc(iError, pSettings);
  end;
end;

procedure VCSetPlotterCurrentLanguageIndex (var iError: Smallint; iIndex: Smallint);
type TVCProc = procedure (var iError: Smallint; iIndex: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPlotterCurrentLanguageIndex');
    if @aproc <> nil then
      aproc(iError, iIndex);
  end;
end;

procedure VCSetPlotterCurrentLanguageName (var iError: Smallint; szLanguageName: PChar);
type TVCProc = procedure (var iError: Smallint; szLanguageName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPlotterCurrentLanguageName');
    if @aproc <> nil then
      aproc(iError, szLanguageName);
  end;
end;

procedure VCSetPlotterCurrentPageSize (var iError: Smallint; iIndex: Smallint);
type TVCProc = procedure (var iError: Smallint; iIndex: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPlotterCurrentPageSize');
    if @aproc <> nil then
      aproc(iError, iIndex);
  end;
end;

procedure VCSetPlotterCurrentPenMapIndex (var iError: Smallint; iIndex: Smallint);
type TVCProc = procedure (var iError: Smallint; iIndex: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPlotterCurrentPenMapIndex');
    if @aproc <> nil then
      aproc(iError, iIndex);
  end;
end;

procedure VCSetPlotterCurrentPenMapName (var iError: Smallint; szPenMapName: PChar);
type TVCProc = procedure (var iError: Smallint; szPenMapName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPlotterCurrentPenMapName');
    if @aproc <> nil then
      aproc(iError, szPenMapName);
  end;
end;

procedure VCSetPlotterDeInitString (var iError: Smallint; sz: PChar);
type TVCProc = procedure (var iError: Smallint; sz: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPlotterDeInitString');
    if @aproc <> nil then
      aproc(iError, sz);
  end;
end;

procedure VCSetPlotterDelimiter (var iError: Smallint; sz: PChar);
type TVCProc = procedure (var iError: Smallint; sz: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPlotterDelimiter');
    if @aproc <> nil then
      aproc(iError, sz);
  end;
end;

procedure VCSetPlotterInitString (var iError: Smallint; sz: PChar);
type TVCProc = procedure (var iError: Smallint; sz: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPlotterInitString');
    if @aproc <> nil then
      aproc(iError, sz);
  end;
end;

procedure VCSetPlotterPenChangeString (var iError: Smallint; sz: PChar);
type TVCProc = procedure (var iError: Smallint; sz: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPlotterPenChangeString');
    if @aproc <> nil then
      aproc(iError, sz);
  end;
end;

procedure VCSetPlotterPenDownString (var iError: Smallint; sz: PChar);
type TVCProc = procedure (var iError: Smallint; sz: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPlotterPenDownString');
    if @aproc <> nil then
      aproc(iError, sz);
  end;
end;

procedure VCSetPlotterPenDrawString (var iError: Smallint; sz: PChar);
type TVCProc = procedure (var iError: Smallint; sz: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPlotterPenDrawString');
    if @aproc <> nil then
      aproc(iError, sz);
  end;
end;

procedure VCSetPlotterPenMapping (var iError: Smallint; iColor: Smallint; iPen: Smallint; dWidth: Double; iSpeed: Smallint);
type TVCProc = procedure (var iError: Smallint; iColor: Smallint; iPen: Smallint; dWidth: Double; iSpeed: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPlotterPenMapping');
    if @aproc <> nil then
      aproc(iError, iColor, iPen, dWidth, iSpeed);
  end;
end;

procedure VCSetPlotterPenMoveString (var iError: Smallint; sz: PChar);
type TVCProc = procedure (var iError: Smallint; sz: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPlotterPenMoveString');
    if @aproc <> nil then
      aproc(iError, sz);
  end;
end;

procedure VCSetPlotterPenSpeedString (var iError: Smallint; sz: PChar);
type TVCProc = procedure (var iError: Smallint; sz: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPlotterPenSpeedString');
    if @aproc <> nil then
      aproc(iError, sz);
  end;
end;

procedure VCSetPlotterPenUpString (var iError: Smallint; sz: PChar);
type TVCProc = procedure (var iError: Smallint; sz: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPlotterPenUpString');
    if @aproc <> nil then
      aproc(iError, sz);
  end;
end;

procedure VCSetPrintSettings (var iError: Smallint; var pSettings: PrintStruct);
type TVCProc = procedure (var iError: Smallint; var pSettings: PrintStruct); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintSettings');
    if @aproc <> nil then
      aproc(iError, pSettings);
  end;
end;

procedure VCSetRefFrameNameDlg (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetRefFrameNameDlg');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCSetSpecificPrinter (var iError: Smallint; szSpecificPrinter: PChar);
type TVCProc = procedure (var iError: Smallint; szSpecificPrinter: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetSpecificPrinter');
    if @aproc <> nil then
      aproc(iError, szSpecificPrinter);
  end;
end;

procedure VCSetUseHPGL2 (var iError: Smallint; tf: WordBool);
type TVCProc = procedure (var iError: Smallint; tf: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetUseHPGL2');
    if @aproc <> nil then
      aproc(iError, tf);
  end;
end;

procedure VCSymCreateRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSymCreateRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSymPlaceRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSymPlaceRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCSymbolMgr (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSymbolMgr');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCTerminateDialogs;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCTerminateDialogs');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCTextLineRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCTextLineRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCTextSettingsRibalog;
type TVCProc = procedure; stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCTextSettingsRibalog');
    if @aproc <> nil then
      aproc;
  end;
end;

procedure VCUpdateBirdseyeView (var iError: Smallint; tfRefresh: WordBool);
type TVCProc = procedure (var iError: Smallint; tfRefresh: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCUpdateBirdseyeView');
    if @aproc <> nil then
      aproc(iError, tfRefresh);
  end;
end;

procedure VCUpdateDialog (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCUpdateDialog');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

procedure VCAddPrintPreset (var iError: Smallint; szPresetName: PChar);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCAddPrintPreset');
    if @aproc <> nil then
      aproc(iError, szPresetName);
  end;
end;

procedure VCDeletePrintPreset (var iError: Smallint; szPresetName: PChar);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCDeletePrintPreset');
    if @aproc <> nil then
      aproc(iError, szPresetName);
  end;
end;

procedure VCSetCurrentPrintPreset (var iError: Smallint; szPresetName: PChar);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetCurrentPrintPreset');
    if @aproc <> nil then
      aproc(iError, szPresetName);
  end;
end;

function VCGetCurrentPrintPreset (var iError: Smallint; szPresetName: PChar): Longint;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
var aproc: TVCProc;
begin
  result := Longint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetCurrentPrintPreset');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetDevice (var iError: Smallint; szPresetName: PChar; szDevice: PChar);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; szDevice: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetDevice');
    if @aproc <> nil then
      aproc(iError, szPresetName, szDevice);
  end;
end;

function VCGetPrintPresetDevice (var iError: Smallint; szPresetName: PChar; szDevice: PChar): Longint;
type TVCProc = function (var iError: Smallint; szPresetName: PChar; szDevice: PChar): Longint; stdcall;
var aproc: TVCProc;
begin
  result := Longint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetDevice');
    if @aproc <> nil then
      result := aproc(iError, szPresetName, szDevice);
  end;
end;

procedure VCSetPrintPresetPageWidth (var iError: Smallint; szPresetName: PChar; dPageWidth: Double);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; dPageWidth: Double); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetPageWidth');
    if @aproc <> nil then
      aproc(iError, szPresetName, dPageWidth);
  end;
end;

function VCGetPrintPresetPageWidth (var iError: Smallint; szPresetName: PChar): Double;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Double; stdcall;
var aproc: TVCProc;
begin
  result := 0.;
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetPageWidth');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetPageHeight (var iError: Smallint; szPresetName: PChar; dPageHeight: Double);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; dPageHeight: Double); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetPageHeight');
    if @aproc <> nil then
      aproc(iError, szPresetName, dPageHeight);
  end;
end;

function VCGetPrintPresetPageHeight (var iError: Smallint; szPresetName: PChar): Double;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Double; stdcall;
var aproc: TVCProc;
begin
  result := 0.;
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetPageHeight');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetMarginLeft (var iError: Smallint; szPresetName: PChar; dMarginLeft: Double);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; dMarginLeft: Double); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetMarginLeft');
    if @aproc <> nil then
      aproc(iError, szPresetName, dMarginLeft);
  end;
end;

function VCGetPrintPresetMarginLeft (var iError: Smallint; szPresetName: PChar): Double;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Double; stdcall;
var aproc: TVCProc;
begin
  result := 0.;
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetMarginLeft');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetMarginBottom (var iError: Smallint; szPresetName: PChar; dMarginBottom: Double);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; dMarginBottom: Double); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetMarginBottom');
    if @aproc <> nil then
      aproc(iError, szPresetName, dMarginBottom);
  end;
end;

function VCGetPrintPresetMarginBottom (var iError: Smallint; szPresetName: PChar): Double;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Double; stdcall;
var aproc: TVCProc;
begin
  result := 0.;
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetMarginBottom');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetMarginRight (var iError: Smallint; szPresetName: PChar; dMarginRight: Double);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; dMarginRight: Double); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetMarginRight');
    if @aproc <> nil then
      aproc(iError, szPresetName, dMarginRight);
  end;
end;

function VCGetPrintPresetMarginRight (var iError: Smallint; szPresetName: PChar): Double;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Double; stdcall;
var aproc: TVCProc;
begin
  result := 0.;
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetMarginRight');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetMarginTop (var iError: Smallint; szPresetName: PChar; dMarginTop: Double);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; dMarginTop: Double); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetMarginTop');
    if @aproc <> nil then
      aproc(iError, szPresetName, dMarginTop);
  end;
end;

function VCGetPrintPresetMarginTop (var iError: Smallint; szPresetName: PChar): Double;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Double; stdcall;
var aproc: TVCProc;
begin
  result := 0.;
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetMarginTop');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetPrintScale (var iError: Smallint; szPresetName: PChar; dPrintScale: Double);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; dPrintScale: Double); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetPrintScale');
    if @aproc <> nil then
      aproc(iError, szPresetName, dPrintScale);
  end;
end;

function VCGetPrintPresetPrintScale (var iError: Smallint; szPresetName: PChar): Double;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Double; stdcall;
var aproc: TVCProc;
begin
  result := 0.;
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetPrintScale');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetOriginBP (var iError: Smallint; szPresetName: PChar; var pOrigin: Point2D);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; var pOrigin: Point2D); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetOriginBP');
    if @aproc <> nil then
      aproc(iError, szPresetName, pOrigin);
  end;
end;

procedure VCGetPrintPresetOriginBP (var iError: Smallint; szPresetName: PChar; var pOrigin: Point2D);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; var pOrigin: Point2D); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetOriginBP');
    if @aproc <> nil then
      aproc(iError, szPresetName, pOrigin);
  end;
end;

procedure VCSetPrintPresetOriginX (var iError: Smallint; szPresetName: PChar; dOriginX: Double);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; dOriginX: Double); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetOriginX');
    if @aproc <> nil then
      aproc(iError, szPresetName, dOriginX);
  end;
end;

function VCGetPrintPresetOriginX (var iError: Smallint; szPresetName: PChar): Double;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Double; stdcall;
var aproc: TVCProc;
begin
  result := 0.;
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetOriginX');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetOriginY (var iError: Smallint; szPresetName: PChar; dOriginY: Double);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; dOriginY: Double); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetOriginY');
    if @aproc <> nil then
      aproc(iError, szPresetName, dOriginY);
  end;
end;

function VCGetPrintPresetOriginY (var iError: Smallint; szPresetName: PChar): Double;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Double; stdcall;
var aproc: TVCProc;
begin
  result := 0.;
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetOriginY');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetPrintView (var iError: Smallint; szPresetName: PChar; nPrintView: Longint);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; nPrintView: Longint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetPrintView');
    if @aproc <> nil then
      aproc(iError, szPresetName, nPrintView);
  end;
end;

function VCGetPrintPresetPrintView (var iError: Smallint; szPresetName: PChar): Longint;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
var aproc: TVCProc;
begin
  result := Longint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetPrintView');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetLandscape (var iError: Smallint; szPresetName: PChar; tfLandscape: WordBool);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; tfLandscape: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetLandscape');
    if @aproc <> nil then
      aproc(iError, szPresetName, tfLandscape);
  end;
end;

function VCGetPrintPresetLandscape (var iError: Smallint; szPresetName: PChar): WordBool;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
var aproc: TVCProc;
begin
  result := WordBool(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetLandscape');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetCopies (var iError: Smallint; szPresetName: PChar; nCopies: Longint);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; nCopies: Longint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetCopies');
    if @aproc <> nil then
      aproc(iError, szPresetName, nCopies);
  end;
end;

function VCGetPrintPresetCopies (var iError: Smallint; szPresetName: PChar): Longint;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
var aproc: TVCProc;
begin
  result := Longint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetCopies');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetRotation (var iError: Smallint; szPresetName: PChar; dRotation: Double);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; dRotation: Double); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetRotation');
    if @aproc <> nil then
      aproc(iError, szPresetName, dRotation);
  end;
end;

function VCGetPrintPresetRotation (var iError: Smallint; szPresetName: PChar): Double;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Double; stdcall;
var aproc: TVCProc;
begin
  result := 0.;
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetRotation');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetMetric (var iError: Smallint; szPresetName: PChar; tfMetric: WordBool);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; tfMetric: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetMetric');
    if @aproc <> nil then
      aproc(iError, szPresetName, tfMetric);
  end;
end;

function VCGetPrintPresetMetric (var iError: Smallint; szPresetName: PChar): WordBool;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
var aproc: TVCProc;
begin
  result := WordBool(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetMetric');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetFastRedraw (var iError: Smallint; szPresetName: PChar; tfFastRedraw: WordBool);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; tfFastRedraw: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetFastRedraw');
    if @aproc <> nil then
      aproc(iError, szPresetName, tfFastRedraw);
  end;
end;

function VCGetPrintPresetFastRedraw (var iError: Smallint; szPresetName: PChar): WordBool;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
var aproc: TVCProc;
begin
  result := WordBool(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetFastRedraw');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetPrintSelected (var iError: Smallint; szPresetName: PChar; tfPrintSelected: WordBool);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; tfPrintSelected: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetPrintSelected');
    if @aproc <> nil then
      aproc(iError, szPresetName, tfPrintSelected);
  end;
end;

function VCGetPrintPresetPrintSelected (var iError: Smallint; szPresetName: PChar): WordBool;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
var aproc: TVCProc;
begin
  result := WordBool(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetPrintSelected');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetPrintToFile (var iError: Smallint; szPresetName: PChar; tfPrintToFile: WordBool);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; tfPrintToFile: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetPrintToFile');
    if @aproc <> nil then
      aproc(iError, szPresetName, tfPrintToFile);
  end;
end;

function VCGetPrintPresetPrintToFile (var iError: Smallint; szPresetName: PChar): WordBool;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
var aproc: TVCProc;
begin
  result := WordBool(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetPrintToFile');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetDateStamp (var iError: Smallint; szPresetName: PChar; tfDateStamp: WordBool);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; tfDateStamp: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetDateStamp');
    if @aproc <> nil then
      aproc(iError, szPresetName, tfDateStamp);
  end;
end;

function VCGetPrintPresetDateStamp (var iError: Smallint; szPresetName: PChar): WordBool;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
var aproc: TVCProc;
begin
  result := WordBool(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetDateStamp');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetAllToBlack (var iError: Smallint; szPresetName: PChar; tfAllToBlack: WordBool);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; tfAllToBlack: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetAllToBlack');
    if @aproc <> nil then
      aproc(iError, szPresetName, tfAllToBlack);
  end;
end;

function VCGetPrintPresetAllToBlack (var iError: Smallint; szPresetName: PChar): WordBool;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
var aproc: TVCProc;
begin
  result := WordBool(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetAllToBlack');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetLW0HasWidth (var iError: Smallint; szPresetName: PChar; tfLW0HasWidth: WordBool);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; tfLW0HasWidth: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetLW0HasWidth');
    if @aproc <> nil then
      aproc(iError, szPresetName, tfLW0HasWidth);
  end;
end;

function VCGetPrintPresetLW0HasWidth (var iError: Smallint; szPresetName: PChar): WordBool;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
var aproc: TVCProc;
begin
  result := WordBool(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetLW0HasWidth');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetLineWidth (var iError: Smallint; szPresetName: PChar; dLineWidth: Double);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; dLineWidth: Double); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetLineWidth');
    if @aproc <> nil then
      aproc(iError, szPresetName, dLineWidth);
  end;
end;

function VCGetPrintPresetLineWidth (var iError: Smallint; szPresetName: PChar): Double;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Double; stdcall;
var aproc: TVCProc;
begin
  result := 0.;
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetLineWidth');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetMovePage (var iError: Smallint; szPresetName: PChar; tfMovePage: WordBool);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; tfMovePage: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetMovePage');
    if @aproc <> nil then
      aproc(iError, szPresetName, tfMovePage);
  end;
end;

function VCGetPrintPresetMovePage (var iError: Smallint; szPresetName: PChar): WordBool;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
var aproc: TVCProc;
begin
  result := WordBool(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetMovePage');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetShowPreview (var iError: Smallint; szPresetName: PChar; tfShowPreview: WordBool);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; tfShowPreview: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetShowPreview');
    if @aproc <> nil then
      aproc(iError, szPresetName, tfShowPreview);
  end;
end;

function VCGetPrintPresetShowPreview (var iError: Smallint; szPresetName: PChar): WordBool;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
var aproc: TVCProc;
begin
  result := WordBool(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetShowPreview');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetPaperSize (var iError: Smallint; szPresetName: PChar; nPaperSize: Longint);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; nPaperSize: Longint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetPaperSize');
    if @aproc <> nil then
      aproc(iError, szPresetName, nPaperSize);
  end;
end;

function VCGetPrintPresetPaperSize (var iError: Smallint; szPresetName: PChar): Longint;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
var aproc: TVCProc;
begin
  result := Longint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetPaperSize');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetPaperLength (var iError: Smallint; szPresetName: PChar; nPaperLength: Longint);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; nPaperLength: Longint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetPaperLength');
    if @aproc <> nil then
      aproc(iError, szPresetName, nPaperLength);
  end;
end;

function VCGetPrintPresetPaperLength (var iError: Smallint; szPresetName: PChar): Longint;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
var aproc: TVCProc;
begin
  result := Longint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetPaperLength');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetPaperWidth (var iError: Smallint; szPresetName: PChar; nPaperWidth: Longint);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; nPaperWidth: Longint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetPaperWidth');
    if @aproc <> nil then
      aproc(iError, szPresetName, nPaperWidth);
  end;
end;

function VCGetPrintPresetPaperWidth (var iError: Smallint; szPresetName: PChar): Longint;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
var aproc: TVCProc;
begin
  result := Longint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetPaperWidth');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetAlwaysCenter (var iError: Smallint; szPresetName: PChar; tfAlwaysCenter: WordBool);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; tfAlwaysCenter: WordBool); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetAlwaysCenter');
    if @aproc <> nil then
      aproc(iError, szPresetName, tfAlwaysCenter);
  end;
end;

function VCGetPrintPresetAlwaysCenter (var iError: Smallint; szPresetName: PChar): WordBool;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): WordBool; stdcall;
var aproc: TVCProc;
begin
  result := WordBool(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetAlwaysCenter');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetStampFormat (var iError: Smallint; szPresetName: PChar; nStampFormat: Longint);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; nStampFormat: Longint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetStampFormat');
    if @aproc <> nil then
      aproc(iError, szPresetName, nStampFormat);
  end;
end;

function VCGetPrintPresetStampFormat (var iError: Smallint; szPresetName: PChar): Longint;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
var aproc: TVCProc;
begin
  result := Longint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetStampFormat');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetStampFontSize (var iError: Smallint; szPresetName: PChar; nStampFontSize: Longint);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; nStampFontSize: Longint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetStampFontSize');
    if @aproc <> nil then
      aproc(iError, szPresetName, nStampFontSize);
  end;
end;

function VCGetPrintPresetStampFontSize (var iError: Smallint; szPresetName: PChar): Longint;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
var aproc: TVCProc;
begin
  result := Longint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetStampFontSize');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetStampLocation (var iError: Smallint; szPresetName: PChar; nStampLocation: Longint);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; nStampLocation: Longint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetStampLocation');
    if @aproc <> nil then
      aproc(iError, szPresetName, nStampLocation);
  end;
end;

function VCGetPrintPresetStampLocation (var iError: Smallint; szPresetName: PChar): Longint;
type TVCProc = function (var iError: Smallint; szPresetName: PChar): Longint; stdcall;
var aproc: TVCProc;
begin
  result := Longint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetStampLocation');
    if @aproc <> nil then
      result := aproc(iError, szPresetName);
  end;
end;

procedure VCSetPrintPresetStampFont (var iError: Smallint; szPresetName: PChar; szStampFont: PChar);
type TVCProc = procedure (var iError: Smallint; szPresetName: PChar; szStampFont: PChar); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCSetPrintPresetStampFont');
    if @aproc <> nil then
      aproc(iError, szPresetName, szStampFont);
  end;
end;

function VCGetPrintPresetStampFont (var iError: Smallint; szPresetName: PChar; szStampFont: PChar): Longint;
type TVCProc = function (var iError: Smallint; szPresetName: PChar; szStampFont: PChar): Longint; stdcall;
var aproc: TVCProc;
begin
  result := Longint(0);
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCGetPrintPresetStampFont');
    if @aproc <> nil then
      result := aproc(iError, szPresetName, szStampFont);
  end;
end;

procedure VCPrintNoDlg (var iError: Smallint);
type TVCProc = procedure (var iError: Smallint); stdcall;
var aproc: TVCProc;
begin
  if hInst <> 0 then
  begin
    @aproc := GetProcAddress(hInst, 'VCPrintNoDlg');
    if @aproc <> nil then
      aproc(iError);
  end;
end;

end.
